using UnityEngine;
using System.Collections;

public class s_PickupRepair : MonoBehaviour
{
	//If you hit the player, ++ on the repairCount and then destroy self
	void OnTriggerStay(Collider other)
	{
		if (other.gameObject.name == "Player")
		{
			s_Player playerScript = other.GetComponent<s_Player>();
			
			if (!playerScript.moving)
			{
				playerScript.repairCount += 1;
				s_Controller controller = Camera.main.GetComponent<s_Controller>();
				controller.UpdateUIPowerups();
				
				AudioManager.PlaySound(AudioManager.powerUp);
				Destroy(gameObject);
			}
		}
	}
}
